<%@ Page Language="C#" AutoEventWireup="true" Inherits="Voxco.Reporting.SaveAsPage" Title="<%$ Resources:Resource, SaveReportAs%>" Theme="Voxco" Codebehind="SaveAs.aspx.cs" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
	<title></title>
    <link href="~/css/ReportingStyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="GroupSelection" runat="server">
    <div>
    
		<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
			<script type="text/javascript">    		

			    if (Telerik.Web.UI.RadTreeView != undefined) {
			        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
			            return "{\"expandedNodes\":" + this._expandedNodesJson +
			                ",\"collapsedNodes\":" + this._collapsedNodesJson +
			                ",\"logEntries\":" + this._logEntriesJson +
			                ",\"selectedNodes\":" + this._selectedNodesJson +
			                ",\"checkedNodes\":" + this._checkedNodesJson +
			                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
			        }
			    }

			    function GetRadWindow()
				{
					var oWindow = null;
					if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog
					else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;//IE (and Moz az well)
	    				
					return oWindow;
				}

				function Cancel()
				{
					GetRadWindow().Close();		
				}
	            
				function ShowSavePanel()
				{
					var _savePanel = document.getElementById('SavingDiv');
					if( _savePanel )
						_savePanel.style.display = 'block';
				}
			</script>
        </telerik:RadScriptBlock>
        
        <asp:ObjectDataSource ID="ReportGroupDataSource" runat="server" SelectMethod="Get"
            TypeName="Voxco.Reporting.DataSource.ReportGroups" InsertMethod="Insert">
            <InsertParameters>
                <asp:Parameter Name="_name" Type="String" />
                <asp:Parameter Name="_parentId" Type="Int32" />
            </InsertParameters>
        </asp:ObjectDataSource>
        
        <telerik:RadScriptManager ID="RadScriptManager1" runat="server"></telerik:RadScriptManager>
        
        <telerik:RadWindowManager ID="RadWindowManager1" runat="server"></telerik:RadWindowManager>
        
        <div id="SavingDiv" style="display:none; position: absolute; height:100px; width:200px; top: 50%; left: 50%; margin-top: -50px; margin-left: -100px; background:Transparent; text-align:center; filter:alpha(opacity=90);-moz-opacity:.9;opacity:.9;">                
            <table style="height:100%;width:100%;">
                <tr>
                    <td valign="middle" align="center">
                    
                        <table style="width:100px; height:30px;background: #fff; border-style:solid; border-width:1px; border-color:#669900; margin: 0 auto; filter:alpha(opacity=90);-moz-opacity:.9;opacity:.9;">
                            <tr>
                                <td>&nbsp;&nbsp;</td>
                                <td id= "TableTd" >
							        <%--<img id="LoadingImage" runat="server" src="" alt="loading" />--%>
						        </td>
                                <td>
                                 <asp:Label ID="Label3" runat="server" Font-Bold="false" Font-Italic="true" Font-Size="8pt" Font-Names="Verdana, Arial, Helvetica, sans-serif" Text="<%$ Resources:Resource, Saving %>"></asp:Label>
                                </td>
                                <td>&nbsp;&nbsp;</td>
                            </tr>
                        </table>
                        
                    </td>
                </tr>
            </table>
        </div>
        
        
        <div id="FolderSelectionDiv" runat="server">
            <div style="width: 100%; vertical-align: middle;">
                <asp:Label ID="Label2" runat="server" Text="<%$ Resources:Resource, ReportGroup %>" Font-Bold="True"></asp:Label>
            </div>
            <div id="saveAsChoice">
                <telerik:RadTreeView ID="ReportGroupTreeView" 
                    runat="server" DataSourceID="ReportGroupDataSource" DataFieldID="ReportGroupId"
                    DataFieldParentID="OwnerGroupId" DataValueField="ReportGroupId" DataTextField="ReportGroupName" MultipleSelect="false"
                    OnDataBound="ReportGroupTreeView_DataBound" OnNodeDataBound="ReportGroupTreeView_NodeBound" Height="100%" Width="100%">
                    <DataBindings>
                        <telerik:RadTreeNodeBinding ExpandedImageUrl="icons/folder.png" ImageUrl="icons/folder_closed.png"
                            TextField="ReportGroupName" ValueField="ReportGroupId" />
                    </DataBindings>
                </telerik:RadTreeView>
            </div>
        </div>
		<div id="saveAsPanel">
			<asp:Panel ID="SaveAsPanel" runat="server" DefaultButton="SaveAsButton">
				<asp:Label ID="Label1" runat="server" Text="<%$ Resources:Resource, ReportNameLabel %>" Font-Bold="True"></asp:Label>
				<asp:TextBox ID="ReportNameTextBox" runat="server" BackColor="white" ForeColor="black" ></asp:TextBox>
				<asp:Button ID="SaveAsButton" CssClass="button" runat="server" OnClick="SaveAsButton_Click" Text="<%$ Resources:Resource, SaveLabel%>" />
				<asp:Button ID="CancelButton" CssClass="button" runat="server" OnClientClick="Cancel()" Text="<%$ Resources:Resource, Cancel%>" />
			</asp:Panel>
        </div>
    </div>
    </form>
</body>
</html>
